/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.shop;

import cz.insophy.inplan.shop.Action;
import cz.insophy.inplan.shop.Actiongram;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.shop.MaterialQuantity;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Product
extends Material {
    private List<Actiongram> actiongrams;

    public Product(String name, Actiongram actiongram) {
        super(name);
        if (actiongram == null) {
            throw new IllegalArgumentException("Actiongram must be defined for product " + name + ".");
        }
        this.actiongrams = Arrays.asList(actiongram);
    }

    public Product(String name) {
        super(name);
    }

    public Product(String name, long materialHorizon) {
        super(name, materialHorizon);
    }

    public Product(String name, String description) {
        super(name, description);
    }

    public Product(String name, String description, long materialHorizon) {
        super(name, description, materialHorizon);
    }

    public void changeActiongrams(List<Actiongram> actiongrams) {
        if (actiongrams.size() < 1) {
            throw new IllegalStateException("There must be at least one actiongram for product " + this.getName() + ".");
        }
        for (Actiongram ag : actiongrams) {
            if (ag != null) continue;
            throw new IllegalArgumentException("Actiongram must be defined for product " + this.getName() + ".");
        }
        this.actiongrams = Collections.unmodifiableList(actiongrams);
    }

    public List<Actiongram> getActiongrams() {
        if (this.actiongrams == null) {
            throw new IllegalStateException("Actiongrams are not initialized yet.");
        }
        return this.actiongrams;
    }

    public Actiongram getActiongram(String actiongramName) {
        Actiongram res = null;
        for (Actiongram ag : this.getActiongrams()) {
            if (!ag.getName().equals(actiongramName)) continue;
            res = ag;
            break;
        }
        return res;
    }

    public Actiongram getDefaultActiongram() {
        return this.actiongrams.get(0);
    }

    public Set<Material> materials() {
        HashSet<Material> mats = new HashSet<Material>();
        this.collectMaterials(mats, this);
        return mats;
    }

    private void collectMaterials(Set<Material> mats, Product product) {
        for (Actiongram ag : product.getActiongrams()) {
            for (Action a : ag.getActions()) {
                mats.addAll(a.getBom().materials());
            }
        }
    }

    public static void collectMpRec(Material matprod, Set<Material> mats) {
        if (mats.add(matprod) && matprod instanceof Product) {
            Product product = (Product)matprod;
            for (Actiongram ag : product.getActiongrams()) {
                for (Action a : ag.getActions()) {
                    for (Material m3 : a.getBom().materials()) {
                        Product.collectMpRec(m3, mats);
                    }
                    mats.addAll(a.getBom().materials());
                    for (MaterialQuantity pi : a.getProduces()) {
                        Product.collectMpRec(pi.getMaterial(), mats);
                    }
                }
            }
        }
    }

    @Override
    public String toString() {
        return "<Product:" + this.getName() + ", horizon=" + this.formatHorizon() + ">";
    }

    private Product(Builder bob) {
        super(bob);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public long getTimeToMake(double qty, long relativeNow) {
        long retVal = 0L;
        for (Actiongram actgr : this.actiongrams) {
            long actgrTime = this.getTimeToMake(qty, relativeNow, actgr.getActions(), actgr.getActions().size() - 1);
            retVal = Math.max(retVal, actgrTime);
        }
        return retVal;
    }

    private long getTimeToMake(double qty, long relativeNow, List<Action> actions, int actIdx) {
        if (actIdx < 0) {
            return 0L;
        }
        Action a = actions.get(actIdx);
        Iterator<MaterialQuantity> it = a.getBom().iterator();
        long mqProdTime = 0L;
        long mqMatTime = 0L;
        while (it.hasNext()) {
            MaterialQuantity mq = it.next();
            Material m3 = mq.getMaterial();
            double q = mq.getQty() * qty * a.getQtyCoef();
            if (m3 instanceof Product) {
                mqProdTime = Math.max(mqProdTime, ((Product)m3).getTimeToMake(q, relativeNow));
                continue;
            }
            mqMatTime = Math.max(mqMatTime, m3.getMaterialHorizon());
        }
        long prevActTime = this.getTimeToMake(qty, relativeNow, actions, actIdx - 1);
        mqMatTime = Math.max(0L, mqMatTime - relativeNow);
        long actionTime = 0L;
        long actionReqsTime = Math.max(mqMatTime, Math.max(mqProdTime, prevActTime));
        actionTime += actionReqsTime;
        actionTime += a.getMinTimeToPrepare();
        return actionTime += a.timeToMake(qty * a.getQtyCoef());
    }

    public static class Builder
    extends Material.Builder {
        @Override
        public Product build() {
            return new Product(this);
        }
    }
}

